<?php $__env->startSection('title', 'Basic DataTables'); ?>

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/datatables.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/select2.css')); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-title'); ?>
<h3> <?php echo app('translator')->get('lang.Categories'); ?></h3>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-items'); ?>
<li class="breadcrumb-item"> <?php echo app('translator')->get('lang.Dashboard'); ?></li>
<li class="breadcrumb-item active"><?php echo app('translator')->get('lang.Categories'); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

	<div class="row">
		<div class="d-flex justify-content-end col-sm-12">
			<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add category')): ?>
			<a href="<?php echo e(route('category.create')); ?>" class="btn btn-primary"><?php echo app('translator')->get('lang.add_slider'); ?></a>
			<?php endif; ?>
		</div>
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display" id="advance-1">
							<thead>
								<tr>
									<th><?php echo app('translator')->get('lang.Name'); ?></th>
									<th><?php echo app('translator')->get('lang.parent_category'); ?></th>
									<th><?php echo app('translator')->get('lang.Image'); ?></th>
									<th><?php echo app('translator')->get('lang.Status'); ?></th>
									<th><?php echo app('translator')->get('lang.free_ads_limit'); ?></th>
									<th></th>
								</tr>
							</thead>
							<tbody>
								<?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
								<tr>
									<td>
										<?php echo e(app()->getLocale() == "en"? $category->name_en:$category->name_ar); ?>

									</td>

									<td><?php echo e($category->parent->name ?? __('lang.main_category')); ?></td>
									<td>
										<img src="<?php echo e(asset($category->image)); ?>" alt="" class="image-fluid" height="90">
									</td>
									<td>
										<?php if($category->end_point ==1): ?>
										<?php echo app('translator')->get('lang.end_Point'); ?>
										<?php else: ?>
										<?php echo app('translator')->get('lang.Not_end_Point'); ?>

										<?php endif; ?>
									</td>
							<td>
								<?php if($category->is_free): ?>
									<span class="badge bg-success"><?php echo e($category->free_ads_limit); ?></span>
								<?php else: ?>
									<span class="badge bg-secondary"><?php echo app('translator')->get('lang.not_free'); ?></span>
								<?php endif; ?>
							</td>
									<td>
										<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit category')): ?>
										<button class="btn btn-primary" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#exampleModal" onclick="getRecord(<?php echo e($category); ?>)"><?php echo app('translator')->get('lang.edit'); ?></button>
										
										<?php endif; ?>
										<?php if($category->children && $category->children->count() > 0): ?>
										<a class="btn btn-info" href="<?php echo e(route('category_details', $category->id)); ?>">
											<?php echo app('translator')->get('lang.details'); ?>
										</a>
										<?php endif; ?>
										<form action="<?php echo e(route('category.destroy')); ?>" method="POST" style="displayPinline-block">
											<?php echo csrf_field(); ?>
											<?php echo method_field('DELETE'); ?>
											<input type="hidden" name="id" value="<?php echo e($category->id); ?>">
											<button type="submit" class="btn btn-danger" style="display:inline-block"
												onclick="return confirm('<?php echo app('translator')->get('lang.are_you_sure_delete'); ?>');">
												<?php echo app('translator')->get('lang.delete'); ?>
											</button>
										</form>

									</td>

								</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

								<?php endif; ?>

							</tbody>
							<tfoot>
								<tr>
									<th><?php echo app('translator')->get('lang.Name'); ?></th>
									<th><?php echo app('translator')->get('lang.parent_category'); ?></th>
									<th><?php echo app('translator')->get('lang.Image'); ?></th>
									<th><?php echo app('translator')->get('lang.Status'); ?></th>
									<th></th>
								</tr>
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>

	</div>
</div>


<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">


	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel"><?php echo app('translator')->get('lang.edit'); ?></h5>
				<button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">

				<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="<?php echo e(route('category.update')); ?>">
					<?php echo csrf_field(); ?>
					<input type="hidden" id="section_id" name="id">
					<div class="row">
						<div class="col-md-12 mb-3">
							<label for="section_name"><?php echo app('translator')->get('lang.name_ar'); ?></label>
							<input class="form-control" id="section_name_ar" type="text" name="name_ar" value="" placeholder="name" required="">
							<div class="valid-feedback">Looks good!</div>
							<div class="invalid-feedback">Please choose a name.</div>

						</div>
						<div class="col-md-12 mb-3">
							<label for="section_name"><?php echo app('translator')->get('lang.name_en'); ?></label>
							<input class="form-control" id="section_name_en" type="text" name="name_en" value="" placeholder="name" required="">
							<div class="valid-feedback">Looks good!</div>
							<div class="invalid-feedback">Please choose a name.</div>

						</div>

					</div>

					<div class="mb-3">
						<div class="col-md-12 mb-3">
							<div class="col">
								<div class="mb-3 row">
									<label class="col-sm-3 col-form-label"><?php echo app('translator')->get('lang.Image'); ?></label>
									<div class="col-sm-9">
										<input class="form-control" type="file" name="image" accept="image/*">
									</div>
								</div>
							</div>
						</div>

					</div>

					<!-- Free Ads Settings -->
					<div class="mb-3">
						<div class="col-md-12 mb-3">
							<label class="d-block" for="edit_is_free">
								<input class="checkbox_animated" id="edit_is_free" type="checkbox" name="is_free" value="1">
								<?php echo app('translator')->get('lang.is_free'); ?>
							</label>
							<small class="text-muted"><?php echo app('translator')->get('lang.is_free_hint'); ?></small>
						</div>
						<div class="col-md-12 mb-3">
							<label for="edit_free_ads_limit"><?php echo app('translator')->get('lang.free_ads_limit'); ?></label>
							<input class="form-control" id="edit_free_ads_limit" type="number" name="free_ads_limit" value="0" min="0">
							<small class="text-muted"><?php echo app('translator')->get('lang.free_ads_limit_hint'); ?></small>
						</div>
					</div>

					
					<div class="modal-footer">
						<button class="btn btn-primary" type="button" data-bs-dismiss="modal">Close</button>
						<button class="btn btn-secondary" type="submit"><?php echo app('translator')->get('lang.edit'); ?></button>
					</div>
				</form>

			</div>

		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/js/datatable/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/datatable/datatables/datatable.custom.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/form-validation-custom.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/select2/select2.full.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/select2/select2-custom.js')); ?>"></script>

<?php $__env->stopSection(); ?>

<script>
	function getRecord(data) {
		document.getElementById("section_name_ar").value = data['name_ar'];
		document.getElementById("section_name_en").value = data['name_en'];
		document.getElementById("section_id").value = data['id'];

		// Set free ads settings
		document.getElementById("edit_is_free").checked = data['is_free'] == 1;
		document.getElementById("edit_free_ads_limit").value = data['free_ads_limit'] || 0;
	}
</script>
<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wikala/public_html/wikala/resources/views/admin/category/index.blade.php ENDPATH**/ ?>