<?php $__env->startSection('title', __('lang.add_ad')); ?>

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/select2.css')); ?>">
<style>
  .img-thumb{height:70px;width:70px;object-fit:cover;border-radius:8px;margin:4px;border:1px solid #eee}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-title'); ?>
<h3><?php echo app('translator')->get('lang.add_ad'); ?></h3>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-items'); ?>
<li class="breadcrumb-item"><?php echo app('translator')->get('lang.ads'); ?></li>
<li class="breadcrumb-item active"><?php echo app('translator')->get('lang.add_ad'); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-sm-12">
            <div class="card">

                <div class="card-body">
                    <form class="needs-validation" novalidate method="POST"
                          enctype="multipart/form-data"
                          action="<?php echo e(route('ads.store')); ?>">
                        <?php echo csrf_field(); ?>

                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label"><?php echo app('translator')->get('lang.Client'); ?></label>
                                <select name="user_id" class="js-example-basic-single form-control" required>
                                    <option value=""><?php echo app('translator')->get('lang.select'); ?></option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($user->id); ?>" <?php if(old('user_id') == $user->id): echo 'selected'; endif; ?>><?php echo e($user->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div class="invalid-feedback"><?php echo app('translator')->get('lang.Client'); ?> <?php echo app('translator')->get('lang.required'); ?></div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label"><?php echo app('translator')->get('lang.Category'); ?></label>
                                <select name="category_id" class="js-example-basic-single form-control" required>
                                    <option value=""><?php echo app('translator')->get('lang.select'); ?></option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>" <?php if(old('category_id') == $category->id): echo 'selected'; endif; ?>><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label"><?php echo app('translator')->get('lang.Type'); ?></label>
                                <select name="type_id" class="js-example-basic-single form-control" required>
                                    <option value=""><?php echo app('translator')->get('lang.select'); ?></option>
                                    <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($type->id); ?>" <?php if(old('type_id') == $type->id): echo 'selected'; endif; ?>><?php echo e($type->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label"><?php echo app('translator')->get('lang.Contact_Method'); ?></label>
                                <input type="text" name="contact_method" class="form-control" value="<?php echo e(old('contact_method')); ?>" required>
                            </div>
                        </div>

                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label"><?php echo app('translator')->get('lang.Title'); ?></label>
                                <input type="text" name="title" class="form-control" value="<?php echo e(old('title')); ?>" required>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label"><?php echo app('translator')->get('lang.price'); ?></label>
                                <input type="number" name="price" class="form-control" value="<?php echo e(old('price')); ?>" min="0" step="0.01">
                            </div>
                        </div>

                        
                        <div class="row mb-3">
                            <div class="col-md-3">
                                <label class="form-label d-block"><?php echo app('translator')->get('lang.Possibility_Negotiable'); ?></label>
                                <input type="hidden" name="negotiable" value="0">
                                <input type="checkbox" name="negotiable" value="1" <?php if(old('negotiable')): echo 'checked'; endif; ?>> <?php echo app('translator')->get('lang.Yes'); ?>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label"><?php echo app('translator')->get('lang.Start_Date'); ?></label>
                                <input type="date" name="start_date" class="form-control" value="<?php echo e(old('start_date')); ?>" required>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label"><?php echo app('translator')->get('lang.End_Date'); ?></label>
                                <input type="date" name="end_date" class="form-control" value="<?php echo e(old('end_date')); ?>" required>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label"><?php echo app('translator')->get('lang.Status'); ?></label>
                                <select name="status" class="form-control">
                                    <option value="under_review" <?php if(old('status')=='under_review'): echo 'selected'; endif; ?>><?php echo app('translator')->get('lang.under_review'); ?></option>
                                    <option value="accepted" <?php if(old('status')=='accepted'): echo 'selected'; endif; ?>><?php echo app('translator')->get('lang.accepted'); ?></option>
                                    <option value="rejected" <?php if(old('status')=='rejected'): echo 'selected'; endif; ?>><?php echo app('translator')->get('lang.rejected'); ?></option>
                                </select>
                            </div>
                        </div>

                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label"><?php echo app('translator')->get('lang.city'); ?></label>
                                <select name="city_id" class="js-example-basic-single form-control" required>
                                    <option value=""><?php echo app('translator')->get('lang.select'); ?></option>
                                    <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($city->id); ?>" <?php if(old('city_id') == $city->id): echo 'selected'; endif; ?>><?php echo e($city->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label"><?php echo app('translator')->get('lang.region'); ?></label>
                                <select name="region_id" class="js-example-basic-single form-control" required>
                                    <option value=""><?php echo app('translator')->get('lang.select'); ?></option>
                                    <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($region->id); ?>" <?php if(old('region_id') == $region->id): echo 'selected'; endif; ?>><?php echo e($region->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        
                        <div class="mb-3">
                            <label class="form-label"><?php echo app('translator')->get('lang.description'); ?></label>
                            <textarea name="description" rows="4" class="form-control" required><?php echo e(old('description')); ?></textarea>
                        </div>

                        
                        <div class="mb-3">
                            <label class="form-label"><?php echo app('translator')->get('lang.Main_Image'); ?></label>
                            <input type="file" name="main_image" id="main_image" class="form-control" accept="image/*">
                            <div id="mainImagePreview" class="mt-2"></div>
                        </div>

                        
                        <div class="mb-3">
                            <label class="form-label"><?php echo app('translator')->get('lang.images'); ?></label>
                            <input type="file" name="images[]" id="images" class="form-control" multiple accept="image/*">
                            <div id="imagesPreview" class="d-flex flex-wrap mt-2"></div>
                        </div>

                        
                        <div class="mb-2 d-flex align-items-center justify-content-between">
                            <label class="form-label m-0"><?php echo app('translator')->get('lang.Attributes'); ?></label>
                            <button type="button" id="addAttributeRow" class="btn btn-sm btn-outline-primary"><?php echo app('translator')->get('lang.add_attribute'); ?> </button>
                        </div>

                        <div id="attributesWrapper">
                            
                            <div class="attribute-row row g-2 align-items-end mb-2" data-index="0">
                                <div class="col-md-5">
                                    <label class="form-label"><?php echo app('translator')->get('lang.Attribute'); ?></label>
                                    <select name="attributes[0][id]" class="js-example-basic-single form-control">
                                        <option value=""><?php echo app('translator')->get('lang.select'); ?></option>
                                        <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($attr->id); ?>"><?php echo e($attr->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-5">
                                    <label class="form-label"><?php echo app('translator')->get('lang.Value'); ?></label>
                                    <input type="text" name="attributes[0][value]" class="form-control" placeholder="<?php echo app('translator')->get('lang.Value'); ?>">
                                </div>
                                <div class="col-md-2">
                                    <button type="button" class="btn btn-outline-danger w-100 remove-attr" disabled>&times;</button>
                                </div>
                            </div>
                        </div>

                        <button class="btn btn-primary mt-3" type="submit"><?php echo app('translator')->get('lang.save'); ?></button>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/js/select2/select2.full.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/select2/select2-custom.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/form-validation-custom.js')); ?>"></script>
<script>
(function(){
  // --- main image preview
  const mainInput = document.getElementById('main_image');
  const mainPreview = document.getElementById('mainImagePreview');
  if(mainInput){
    mainInput.addEventListener('change', function(){
      mainPreview.innerHTML = '';
      const f = this.files?.[0];
      if(!f) return;
      const img = document.createElement('img');
      img.className = 'img-thumb';
      img.src = URL.createObjectURL(f);
      mainPreview.appendChild(img);
    });
  }

  // --- gallery preview
  const imgs = document.getElementById('images');
  const imgsPreview = document.getElementById('imagesPreview');
  if(imgs){
    imgs.addEventListener('change', function(){
      imgsPreview.innerHTML = '';
      Array.from(this.files || []).forEach(f=>{
        const img = document.createElement('img');
        img.className = 'img-thumb';
        img.src = URL.createObjectURL(f);
        imgsPreview.appendChild(img);
      });
    });
  }

  // --- attributes dynamic rows
  const wrapper = document.getElementById('attributesWrapper');
  const btnAdd = document.getElementById('addAttributeRow');
  let idx = 0;

  btnAdd.addEventListener('click', function(){
    idx++;
    const row = document.createElement('div');
    row.className = 'attribute-row row g-2 align-items-end mb-2';
    row.setAttribute('data-index', idx);

    row.innerHTML = `
      <div class="col-md-5">
        <label class="form-label"><?php echo app('translator')->get('lang.Attribute'); ?></label>
        <select name="attributes[${idx}][id]" class="js-example-basic-single form-control">
          <option value=""><?php echo app('translator')->get('lang.select'); ?></option>
          <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($attr->id); ?>"><?php echo e($attr->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-5">
        <label class="form-label"><?php echo app('translator')->get('lang.Value'); ?></label>
        <input type="text" name="attributes[${idx}][value]" class="form-control" placeholder="<?php echo app('translator')->get('lang.Value'); ?>">
      </div>
      <div class="col-md-2">
        <button type="button" class="btn btn-outline-danger w-100 remove-attr">&times;</button>
      </div>
    `;
    wrapper.appendChild(row);

    // re-init select2 on new select
    $(row).find('select').select2({ width: '100%' });
  });

  // remove attribute row
  wrapper.addEventListener('click', function(e){
    if(e.target.classList.contains('remove-attr')){
      const rows = wrapper.querySelectorAll('.attribute-row');
      if(rows.length > 1){
        e.target.closest('.attribute-row').remove();
      }
    }
  });
})();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wikala/public_html/wikala/resources/views/admin/ads/add.blade.php ENDPATH**/ ?>