<?php $__env->startSection('title', __('lang.Set_Sponsor')); ?>

<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-title'); ?>
<h3><?php echo app('translator')->get('lang.Set_Sponsor'); ?></h3>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-items'); ?>
<li class="breadcrumb-item"><?php echo app('translator')->get('lang.ads'); ?></li>
<li class="breadcrumb-item active"><?php echo app('translator')->get('lang.Set_Sponsor'); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header pb-0">
                    <h5><?php echo app('translator')->get('lang.Set_Sponsor_For_Ad'); ?>: <?php echo e($ad->title); ?></h5>
                </div>
                <div class="card-body">
                    <form class="needs-validation" method="POST" action="<?php echo e(route('ads.setSponsor', $ad->id)); ?>" novalidate>
                        <?php echo csrf_field(); ?>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label" for="ad_number"><?php echo app('translator')->get('lang.Ad_Number'); ?></label>
                                <input type="text" class="form-control" value="<?php echo e($ad->ad_number); ?>" disabled>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label" for="title"><?php echo app('translator')->get('lang.Title'); ?></label>
                                <input type="text" class="form-control" value="<?php echo e($ad->title); ?>" disabled>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label" for="sponsored_price"><?php echo app('translator')->get('lang.Sponsored_Price'); ?> (<?php echo app('translator')->get('lang.sar'); ?>) <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" min="0" class="form-control <?php $__errorArgs = ['sponsored_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="sponsored_price" id="sponsored_price"
                                    value="<?php echo e(old('sponsored_price', $ad->sponsored_price ?? 0)); ?>" required>
                                <?php $__errorArgs = ['sponsored_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <small class="text-muted"><?php echo app('translator')->get('lang.higher_price_appears_first'); ?></small>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label"><?php echo app('translator')->get('lang.Current_Status'); ?></label>
                                <div class="mt-2">
                                    <?php if($ad->is_sponsored): ?>
                                    <span class="badge bg-success"><?php echo app('translator')->get('lang.sponsored'); ?></span>
                                    <span class="text-muted"><?php echo app('translator')->get('lang.Current_Price'); ?>: <?php echo e($ad->sponsored_price); ?> <?php echo app('translator')->get('lang.sar'); ?></span>
                                    <?php else: ?>
                                    <span class="badge bg-secondary"><?php echo app('translator')->get('lang.not_sponsored'); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <button class="btn btn-success" type="submit"><?php echo app('translator')->get('lang.Set_Sponsor'); ?></button>
                                <a href="<?php echo e(route('ads.details', $ad->id)); ?>" class="btn btn-secondary"><?php echo app('translator')->get('lang.cancel'); ?></a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/js/form-validation-custom.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wikala/public_html/wikala/resources/views/admin/ads/editSponsor.blade.php ENDPATH**/ ?>