<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

 class CreateDiscountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('discounts', function (Blueprint $table) {
            $table->id();
            $table->boolean('active')->default(true);
            $table->string('code');
            $table->integer('coupons_number');
            $table->integer('used_coupons')->default(0);
            $table->integer('coupons_user_number');
            $table->date('start_date');
            $table->date('end_date');
            $table->enum('type',['cash','percentage']);
            $table->string('value');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('discounts');
    }
};
