<?php

namespace App\Http\Requests\Admin\RejectedReasons;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required', 
            'description' => 'required', 
        ];
    }

    public function messages()
    {
        return [
            'name.required' => __('lang.The_name_is_required'),
            'description.required' => __('lang.The_description_is_required'),
        ];
    }
}
