<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Auth;

class CheckUserActiviation
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {

        if(Auth::check())
        {
            if(Auth::user()->active==0)
            {
                Auth::logout();
                return redirect('login')->withErrors(['password' => 'Please contact with the Admin']);
            }
            return $next($request);
        }
        
    }
}
